# Manual de Instalação cPanel VPS - Sistema Villa Joias
## Guia Completo para VPS Platinum Hostgator com cPanel

**Versão:** 3.0 - cPanel VPS Edition  
**Data:** 19 de Junho de 2025  
**Desenvolvido por:** Manus AI - CIO Villa Joias  
**Público-alvo:** Usuários que preferem interface visual  

---

## 🎯 Sobre Este Manual

Este manual foi criado especificamente para instalar o Sistema Villa Joias usando o **cPanel do VPS Platinum da Hostgator**. É a forma mais fácil e visual de fazer a instalação, sem precisar usar comandos de terminal. Perfeito para quem prefere interfaces gráficas!

### Por que cPanel no VPS é melhor:
- 🖱️ **Interface visual** - Tudo com cliques, sem comandos
- 📁 **Gerenciador de arquivos** integrado
- 🗄️ **Criação de banco** com poucos cliques
- 🌐 **Configuração de domínio** simplificada
- 🔒 **SSL automático** com Let's Encrypt
- 📊 **Monitoramento visual** de recursos

### Tempo estimado: 30-45 minutos
### Dificuldade: Muito Fácil (interface visual)

---

## 📋 Pré-requisitos

### 1. VPS Platinum com cPanel
- ✅ **VPS Platinum ativo** na Hostgator
- ✅ **cPanel instalado** (vem por padrão)
- ✅ **URL do cPanel** recebida por email
- ✅ **Usuário e senha** do cPanel

### 2. Domínio Configurado
- ✅ **Domínio no GoDaddy** (ou outro registrador)
- ✅ **DNS apontando** para o IP do VPS
- ✅ **Propagação DNS** concluída

### 3. Arquivos do Sistema
- ✅ **Download** do `villa_joias_cpanel_vps.zip`
- ✅ **Arquivos extraídos** no seu computador

---

## 🔑 Passo 1: Acessando o cPanel do VPS

### 1.1 Localizando Dados de Acesso

Quando você contratou o VPS Platinum, a Hostgator enviou um email com:

**Procure por:**
- **URL do cPanel:** `https://SEU_IP:2083` ou `https://seudominio.com:2083`
- **Usuário:** Geralmente o nome do domínio principal
- **Senha:** Senha definida na contratação
- **IP do VPS:** Para configuração DNS

**⚠️ Importante:** Se não encontrou o email, acesse o portal da Hostgator ou ligue 0800 600 2000.

### 1.2 Primeiro Acesso ao cPanel

**Abra seu navegador e acesse:**
```
https://SEU_IP_DO_VPS:2083
```

**Ou se já configurou o domínio:**
```
https://seudominio.com:2083
```

**Na tela de login:**
1. **Digite seu usuário** (nome do domínio ou usuário fornecido)
2. **Digite sua senha**
3. **Clique em "Entrar"**

**Se aparecer aviso de segurança:**
- Clique em "Avançado"
- Clique em "Prosseguir para [endereço]"
- Isso é normal em VPS novos

### 1.3 Conhecendo o cPanel

Após fazer login, você verá o painel principal do cPanel com várias seções:

**Seções importantes para nossa instalação:**
- **📁 Arquivos:** Gerenciador de Arquivos, Backup
- **🗄️ Bancos de Dados:** MySQL, phpMyAdmin
- **🌐 Domínios:** Subdomínios, Redirecionamentos
- **🔒 Segurança:** SSL/TLS, Proteção por Senha
- **📊 Métricas:** Uso de CPU, Memória, Disco

---

## 🌐 Passo 2: Configurando Domínio (se necessário)

### 2.1 Verificando Domínio Principal

**No cPanel, procure por "Domínios" ou "Addon Domains":**

1. **Clique em "Domínios"**
2. **Verifique se seu domínio** está listado
3. **Se não estiver**, clique em "Criar um Novo Domínio"

### 2.2 Adicionando Domínio (se necessário)

**Se seu domínio não estiver configurado:**

1. **Clique em "Criar um Novo Domínio"**
2. **Preencha:**
   - **Domínio:** `seudominio.com.br`
   - **Subdomínio:** Deixe em branco
   - **Pasta do Documento:** `public_html/seudominio.com.br` (ou deixe padrão)
3. **Clique em "Enviar"**

### 2.3 Configurando DNS no GoDaddy

**Se ainda não configurou o DNS:**

1. **Acesse:** https://www.godaddy.com/
2. **Faça login** na sua conta
3. **Vá em "Meus Produtos" > "Domínios"**
4. **Clique em "DNS"** ao lado do seu domínio
5. **Configure registros A:**
   - **Nome:** `@` | **Valor:** `IP_DO_VPS` | **TTL:** 1 hora
   - **Nome:** `www` | **Valor:** `IP_DO_VPS` | **TTL:** 1 hora
6. **Salve as alterações**

**Aguarde 15 minutos a 6 horas** para propagação DNS.

---

## 🗄️ Passo 3: Criando Banco de Dados

### 3.1 Acessando MySQL

**No cPanel, procure por "Bancos de Dados MySQL":**

1. **Clique em "Bancos de Dados MySQL"**
2. **Você verá a tela de gerenciamento** de bancos

### 3.2 Criando Banco de Dados

**Na seção "Criar Novo Banco de Dados":**

1. **Digite o nome:** `villa_joias`
2. **Clique em "Criar Banco de Dados"**
3. **Confirme a criação** clicando "Voltar"

**Anote o nome completo:** Geralmente fica `usuario_villa_joias`

### 3.3 Criando Usuário do Banco

**Na seção "Usuários MySQL":**

1. **Digite o nome de usuário:** `villa_admin`
2. **Digite uma senha forte:** `VillaJoias2025!`
3. **Confirme a senha**
4. **Clique em "Criar Usuário"**

**Anote o nome completo:** Geralmente fica `usuario_villa_admin`

### 3.4 Associando Usuário ao Banco

**Na seção "Adicionar Usuário ao Banco de Dados":**

1. **Selecione o usuário:** `usuario_villa_admin`
2. **Selecione o banco:** `usuario_villa_joias`
3. **Clique em "Adicionar"**
4. **Na tela de privilégios:**
   - ✅ Marque "TODOS OS PRIVILÉGIOS"
   - **Clique em "Fazer Alterações"**

### 3.5 Testando Conexão

**Para testar se deu certo:**

1. **Clique em "phpMyAdmin"** (na seção Bancos de Dados)
2. **Faça login com:**
   - **Usuário:** `usuario_villa_admin`
   - **Senha:** `VillaJoias2025!`
3. **Deve aparecer** o banco `usuario_villa_joias` na lista

---

## 📁 Passo 4: Upload dos Arquivos

### 4.1 Acessando Gerenciador de Arquivos

**No cPanel, procure por "Gerenciador de Arquivos":**

1. **Clique em "Gerenciador de Arquivos"**
2. **Aguarde carregar** a interface
3. **Você verá** uma estrutura de pastas

### 4.2 Navegando para Pasta Correta

**Localize a pasta do seu domínio:**

- **Se domínio principal:** Vá para `public_html`
- **Se domínio adicional:** Vá para `public_html/seudominio.com.br`

**Clique duas vezes** na pasta para entrar.

### 4.3 Fazendo Upload do Sistema

**Na pasta correta:**

1. **Clique em "Upload"** (botão no topo)
2. **Nova aba abrirá** com interface de upload
3. **Clique em "Selecionar Arquivo"**
4. **Escolha o arquivo:** `villa_joias_cpanel_vps.zip`
5. **Aguarde o upload** (pode demorar alguns minutos)
6. **Feche a aba** quando concluído

### 4.4 Extraindo Arquivos

**De volta ao Gerenciador de Arquivos:**

1. **Localize o arquivo** `villa_joias_cpanel_vps.zip`
2. **Clique com botão direito** no arquivo
3. **Selecione "Extrair"**
4. **Confirme a extração** clicando "Extract Files"
5. **Aguarde a extração** (1-2 minutos)

### 4.5 Organizando Arquivos

**Após extração:**

1. **Entre na pasta** `villa_joias_cpanel_vps`
2. **Selecione todos os arquivos** (Ctrl+A)
3. **Clique em "Mover"**
4. **Mova para a pasta pai** (um nível acima)
5. **Delete a pasta vazia** `villa_joias_cpanel_vps`
6. **Delete o arquivo** `villa_joias_cpanel_vps.zip`

**Agora você deve ver** na pasta principal:
- `install.php`
- `index.php`
- `api/`
- `assets/`
- `database.sql`
- E outros arquivos...

---

## ⚙️ Passo 5: Executando Instalação

### 5.1 Acessando Instalador Web

**Abra seu navegador e acesse:**
```
https://seudominio.com.br/install.php
```

**Ou se ainda não configurou domínio:**
```
https://SEU_IP_DO_VPS/install.php
```

### 5.2 Tela 1: Verificação de Requisitos

**Você verá a primeira tela do instalador:**

- ✅ **PHP 8.1+:** Deve estar OK
- ✅ **MySQL:** Deve estar OK
- ✅ **Extensões PHP:** Todas devem estar OK
- ✅ **Permissões de Pasta:** Devem estar OK

**Se algum item estiver ❌:**
- Entre em contato com suporte Hostgator
- Ou continue (pode funcionar mesmo assim)

**Clique em "Continuar para Configuração do Banco"**

### 5.3 Tela 2: Configuração do Banco

**Preencha com os dados criados anteriormente:**

- **Servidor:** `localhost`
- **Nome do Banco:** `usuario_villa_joias` (nome completo)
- **Usuário:** `usuario_villa_admin` (nome completo)
- **Senha:** `VillaJoias2025!`
- **Porta:** `3306`

**Clique em "Testar Conexão"**
- Deve aparecer: ✅ "Conexão estabelecida com sucesso!"

**Clique em "Continuar para Criação das Tabelas"**

### 5.4 Tela 3: Criação das Tabelas

**Na tela de criação das tabelas:**

1. **Clique em "Criar Tabelas do Sistema"**
2. **Aguarde o processo** (1-3 minutos)
3. **Deve aparecer:** ✅ "32 tabelas criadas com sucesso!"

**Se der erro:**
- Verifique se dados do banco estão corretos
- Tente novamente
- Entre em contato com suporte se persistir

**Clique em "Continuar para Configuração do Administrador"**

### 5.5 Tela 4: Configuração do Administrador

**Crie o usuário administrador:**

- **Nome:** `Administrador Villa Joias`
- **Email:** `admin@seudominio.com.br` (use seu domínio real)
- **Senha:** Crie uma senha forte (anote!)
- **Confirmar Senha:** Repita a senha

**Clique em "Criar Administrador"**

### 5.6 Tela 5: Configurações Gerais

**Configure dados da empresa:**

- **Nome da Empresa:** `Villa Joias` (ou seu nome)
- **CNPJ:** Seu CNPJ real
- **Telefone:** Seu telefone
- **Email:** Email da empresa
- **Endereço:** Endereço completo
- **Fuso Horário:** `America/Sao_Paulo`
- **Moeda:** `Real (R$)`

**Configurações avançadas:**
- ✅ **Ativar backup automático**
- ✅ **Ativar assistente de IA (Manus)**
- ✅ **Ativar módulo de cobrança**
- ✅ **Ativar relatórios avançados**

**Clique em "Salvar Configurações"**

### 5.7 Tela 6: Finalização

**Instalação concluída:**

- ✅ "Sistema instalado com sucesso!"
- **URL do Sistema:** `https://seudominio.com.br`
- **Email Admin:** O que você definiu
- **Senha Admin:** A que você criou

**⚠️ IMPORTANTE:** Anote esses dados!

**Clique em "Acessar Sistema"**

---

## 🔒 Passo 6: Configurando SSL

### 6.1 Acessando SSL no cPanel

**De volta ao cPanel:**

1. **Procure por "SSL/TLS"**
2. **Clique em "SSL/TLS"**
3. **Você verá opções** de certificado

### 6.2 Let's Encrypt (Gratuito)

**Se disponível no seu cPanel:**

1. **Procure por "Let's Encrypt"**
2. **Clique em "Let's Encrypt SSL"**
3. **Selecione seu domínio**
4. **Marque "www" também**
5. **Clique em "Issue"**
6. **Aguarde 1-2 minutos**

### 6.3 SSL Automático (Hostgator)

**Alternativa mais comum:**

1. **Na seção SSL/TLS**
2. **Clique em "AutoSSL"**
3. **Ative para seu domínio**
4. **Aguarde processamento** (pode demorar até 24h)

### 6.4 Forçando HTTPS

**Para redirecionar HTTP para HTTPS:**

1. **No cPanel, vá em "Gerenciador de Arquivos"**
2. **Abra a pasta** do seu domínio
3. **Edite o arquivo** `.htaccess` (se não existir, crie)
4. **Adicione no início:**

```apache
RewriteEngine On
RewriteCond %{HTTPS} off
RewriteRule ^(.*)$ https://%{HTTP_HOST}%{REQUEST_URI} [L,R=301]
```

5. **Salve o arquivo**

---

## ✅ Passo 7: Primeiro Acesso e Teste

### 7.1 Acessando o Sistema

**Abra seu navegador e acesse:**
```
https://seudominio.com.br
```

**Você deve ver:**
- Tela de login do Sistema Villa Joias
- Design dourado e escuro
- Campos de email e senha

### 7.2 Fazendo Login

**Use as credenciais criadas na instalação:**
- **Email:** `admin@seudominio.com.br`
- **Senha:** A senha que você criou

**Clique em "Entrar"**

### 7.3 Explorando o Dashboard

**Após login, você verá:**
- ✅ **Dashboard principal** com métricas
- ✅ **Menu lateral** com todas as opções
- ✅ **Chat Manus** no canto inferior direito
- ✅ **Design responsivo** Villa Joias

### 7.4 Testando Funcionalidades

**Teste 1: Criar um Caixa**
1. **Menu lateral:** Clique em "Caixas"
2. **Botão:** Clique "Novo Caixa"
3. **Preencha:**
   - Nome: `Banco Principal`
   - Tipo: `Capital de Giro`
   - Saldo Inicial: `10000.00`
4. **Clique "Salvar"**
5. ✅ **Deve aparecer** na lista

**Teste 2: Chat com Manus**
1. **Clique no ícone** de chat (canto inferior direito)
2. **Digite:** "Como está o sistema?"
3. ✅ **Manus deve responder** com informações

**Teste 3: Criar Representante**
1. **Menu:** Clique em "Representantes"
2. **Botão:** "Novo Representante"
3. **Preencha dados** básicos
4. ✅ **Salve e verifique** na lista

---

## 🛡️ Passo 8: Configurações de Segurança

### 8.1 Removendo Arquivos de Instalação

**Por segurança, remova:**

1. **No Gerenciador de Arquivos**
2. **Localize e delete:**
   - `install.php`
   - `database.sql`
   - `README.md` (opcional)

### 8.2 Configurando Backup no cPanel

**Ativando backup automático:**

1. **No cPanel, clique em "Backup"**
2. **Configure backup automático:**
   - **Frequência:** Diária
   - **Retenção:** 7 dias
   - **Incluir:** Arquivos e banco de dados
3. **Ative notificações** por email

### 8.3 Configurando Proteção de Diretório

**Protegendo pastas sensíveis:**

1. **No cPanel, clique em "Proteção de Diretório"**
2. **Proteja as pastas:**
   - `/api/config/`
   - `/backups/`
   - `/logs/`
3. **Defina usuário e senha** para cada pasta

### 8.4 Configurando Firewall

**Se disponível no cPanel:**

1. **Procure por "Firewall" ou "Segurança"**
2. **Ative proteção** contra ataques
3. **Configure lista branca** de IPs (opcional)

---

## 📊 Passo 9: Monitoramento e Otimização

### 9.1 Verificando Recursos

**No cPanel, monitore:**

1. **CPU Usage:** Deve estar baixo (< 50%)
2. **Memory Usage:** Deve estar controlado (< 80%)
3. **Disk Usage:** Acompanhe crescimento
4. **Bandwidth:** Monitore tráfego

### 9.2 Otimizando Performance

**Configurações recomendadas:**

1. **No cPanel, ative:**
   - **Compressão GZIP**
   - **Cache de arquivos estáticos**
   - **Otimização de imagens**

2. **No arquivo .htaccess, adicione:**
```apache
# Cache de arquivos
<IfModule mod_expires.c>
ExpiresActive on
ExpiresByType text/css "access plus 1 month"
ExpiresByType application/javascript "access plus 1 month"
ExpiresByType image/png "access plus 1 month"
ExpiresByType image/jpg "access plus 1 month"
</IfModule>
```

### 9.3 Configurando Logs

**Para monitoramento:**

1. **No cPanel, acesse "Logs de Erro"**
2. **Configure retenção** de 30 dias
3. **Ative alertas** para erros críticos

---

## 🚨 Solução de Problemas

### Problema: "Erro 500 - Internal Server Error"

**Soluções:**

1. **Verifique logs de erro** no cPanel
2. **Verifique arquivo .htaccess** (renomeie temporariamente)
3. **Verifique permissões** das pastas (755 para pastas, 644 para arquivos)
4. **Entre em contato** com suporte Hostgator

### Problema: "Não consegue conectar no banco"

**Soluções:**

1. **Verifique dados** na configuração
2. **Teste conexão** via phpMyAdmin
3. **Recrie usuário** do banco se necessário
4. **Verifique se banco** existe

### Problema: "Site não carrega"

**Soluções:**

1. **Verifique DNS** (pode demorar até 48h)
2. **Teste com IP** direto do VPS
3. **Verifique configuração** do domínio no cPanel
4. **Limpe cache** do navegador

### Problema: "SSL não funciona"

**Soluções:**

1. **Aguarde processamento** (até 24h)
2. **Force renovação** no cPanel
3. **Verifique configuração** do domínio
4. **Entre em contato** com suporte

---

## 📞 Suporte e Contatos

### Hostgator VPS
- **Telefone:** 0800 600 2000
- **Chat:** Portal do cliente 24/7
- **Email:** Através do portal
- **Documentação:** https://suporte.hostgator.com.br/

### GoDaddy (DNS)
- **Telefone:** 0800 606 4656
- **Chat:** Disponível no painel
- **Suporte:** 24/7

### Sistema Villa Joias
- **Email:** suporte@villajoias.com.br
- **WhatsApp:** (11) 99999-9999
- **Horário:** Segunda a Sexta, 8h às 18h

### Informações para Suporte

**Sempre tenha em mãos:**
- URL do seu cPanel
- Domínio configurado
- Versão do PHP (visível no cPanel)
- Mensagem de erro completa
- Passos que levaram ao problema

---

## 🎉 Parabéns!

Se você chegou até aqui, **seu Sistema Villa Joias está 100% funcionando via cPanel!**

### O que você conquistou:

✅ **Instalação via cPanel** - Interface visual amigável  
✅ **Banco de dados** configurado e funcionando  
✅ **Sistema completo** instalado e testado  
✅ **SSL configurado** para segurança  
✅ **Backup automático** ativado  
✅ **Monitoramento** configurado  

### Próximos passos:

1. **Configure seus dados reais** (caixas, representantes, categorias)
2. **Treine sua equipe** no uso do sistema
3. **Monitore performance** através do cPanel
4. **Configure WhatsApp** para cobrança (próxima fase)

**Seu Sistema Villa Joias está pronto para revolucionar sua gestão financeira!** 🚀

---

**Manual criado com excelência por Manus AI**  
**CIO Virtual da Villa Joias**  
**"Simplicidade visual, resultados profissionais"**

