# README - Sistema Villa Joias cPanel VPS Edition

## 🎯 Instalação via cPanel - Super Fácil!

**Versão:** 3.0 - cPanel VPS Edition  
**Compatível com:** VPS Platinum Hostgator com cPanel  
**Dificuldade:** Muito Fácil (Interface Visual)  

---

## 🚀 Instalação Rápida (5 Passos)

### 1. Acesse o cPanel
```
https://SEU_IP_DO_VPS:2083
ou
https://seudominio.com:2083
```

### 2. Crie o Banco de Dados
- Vá em "MySQL Databases"
- Crie banco: `villa_joias`
- Crie usuário: `villa_admin`
- Senha: `VillaJoias2025!`
- Associe usuário ao banco

### 3. Faça Upload dos Arquivos
- Vá em "File Manager"
- Entre na pasta `public_html`
- Upload do arquivo `villa_joias_cpanel_vps.zip`
- Extraia os arquivos
- Mova para pasta principal

### 4. Execute a Instalação
- Acesse: `https://seudominio.com.br/install.php`
- Siga o assistente passo a passo
- Configure banco, admin e empresa
- Aguarde finalização

### 5. Configure SSL (Opcional)
- No cPanel, vá em "SSL/TLS"
- Ative "AutoSSL" ou "Let's Encrypt"
- Aguarde processamento

**🎉 Pronto! Sistema funcionando!**

---

## 📦 Arquivos Incluídos

### Sistema Principal
- `install.php` - Instalador web visual
- `index.php` - Página principal
- `config.php` - Configurações (gerado na instalação)
- `database.sql` - Estrutura do banco

### Backend (API)
- `api/` - APIs REST completas
- `api/config/` - Configurações da API
- `api/models/` - Modelos de dados
- `api/routes/` - Rotas da API
- `api/services/` - Serviços (IA, backup, etc.)

### Frontend
- `assets/` - CSS, JS, imagens
- `components/` - Componentes React
- `pages/` - Páginas do sistema

### Documentação
- `README.md` - Este arquivo
- `MANUAL_CPANEL_VPS.md` - Manual completo
- `CHECKLIST_CPANEL.md` - Lista de verificação

---

## 🔧 Configuração do cPanel

### Banco de Dados MySQL
```
Nome do Banco: usuario_villa_joias
Usuário: usuario_villa_admin
Senha: VillaJoias2025!
Host: localhost
Porta: 3306
```

### Estrutura de Arquivos
```
public_html/
├── install.php          # Instalador web
├── index.php           # Página principal
├── config.php          # Configurações (gerado)
├── database.sql        # SQL do banco
├── api/                # Backend
├── assets/             # Frontend
├── uploads/            # Arquivos enviados
├── backups/            # Backups automáticos
└── logs/               # Logs do sistema
```

### Permissões Necessárias
- Pastas: 755
- Arquivos: 644
- Pasta uploads/: 777
- Pasta backups/: 777
- Pasta logs/: 777

---

## ⚙️ Configurações Recomendadas

### PHP (no cPanel)
- **Versão:** PHP 8.1 ou superior
- **Memory Limit:** 256M
- **Max Execution Time:** 300
- **Upload Max Size:** 64M
- **Post Max Size:** 64M

### MySQL
- **Versão:** 5.7 ou superior
- **Charset:** utf8mb4
- **Collation:** utf8mb4_unicode_ci

### SSL/HTTPS
- **AutoSSL:** Ativado
- **Force HTTPS:** Sim
- **HSTS:** Recomendado

---

## 🛠️ Funcionalidades

### Módulos Principais
- ✅ **Controle de Caixas** - Gestão financeira
- ✅ **Representantes** - Cadastro e controle
- ✅ **Transações** - Entradas e saídas
- ✅ **Relatórios** - Análises detalhadas
- ✅ **Dashboard** - Visão geral

### Módulos Avançados
- ✅ **IA Manus** - Assistente inteligente
- ✅ **Cobrança** - Gestão de inadimplência
- ✅ **Backup** - Automático e manual
- ✅ **Usuários** - Controle de acesso
- ✅ **Cartões** - Gestão de cartões

### Recursos Técnicos
- ✅ **API REST** - Integração completa
- ✅ **Interface Responsiva** - Mobile friendly
- ✅ **Segurança** - Criptografia e tokens
- ✅ **Performance** - Cache e otimização
- ✅ **Logs** - Monitoramento completo

---

## 📊 Requisitos do Sistema

### VPS Mínimo
- **RAM:** 2GB (VPS Platinum tem 8GB ✅)
- **CPU:** 2 cores (VPS Platinum tem 4 ✅)
- **Disco:** 20GB (VPS Platinum tem 200GB ✅)
- **Bandwidth:** 100GB/mês

### Software
- **OS:** Linux (Ubuntu/CentOS)
- **Web Server:** Apache 2.4+
- **PHP:** 8.0+ com extensões
- **MySQL:** 5.7+ ou MariaDB 10.3+
- **cPanel:** Versão atual

### Extensões PHP Necessárias
- mysqli, pdo, pdo_mysql
- json, curl, mbstring
- openssl, zip, gd
- fileinfo, xml

---

## 🔒 Segurança

### Configurações Automáticas
- ✅ **Senhas criptografadas** (bcrypt)
- ✅ **Tokens JWT** para autenticação
- ✅ **Headers de segurança** configurados
- ✅ **Proteção CSRF** ativada
- ✅ **Validação de entrada** rigorosa

### Recomendações Adicionais
- 🔐 **Altere senhas** padrão
- 🔐 **Ative 2FA** quando disponível
- 🔐 **Monitore logs** regularmente
- 🔐 **Mantenha backups** atualizados
- 🔐 **Atualize sistema** periodicamente

---

## 📈 Performance

### Otimizações Incluídas
- ⚡ **Compressão GZIP** ativada
- ⚡ **Cache de arquivos** configurado
- ⚡ **Minificação** de CSS/JS
- ⚡ **Lazy loading** de imagens
- ⚡ **Database indexing** otimizado

### Monitoramento
- 📊 **CPU Usage** - Via cPanel
- 📊 **Memory Usage** - Via cPanel
- 📊 **Disk Usage** - Via cPanel
- 📊 **Bandwidth** - Via cPanel
- 📊 **Error Logs** - Via sistema

---

## 🔄 Backup e Manutenção

### Backup Automático
- **Frequência:** Diário
- **Retenção:** 7 dias
- **Inclui:** Arquivos + Banco
- **Local:** Pasta /backups/
- **Notificação:** Email

### Backup Manual
```
1. No cPanel, vá em "Backup"
2. Clique em "Download a Full Website Backup"
3. Aguarde processamento
4. Download do arquivo
```

### Manutenção Preventiva
- 🔧 **Limpeza de logs** (semanal)
- 🔧 **Otimização do banco** (mensal)
- 🔧 **Verificação de segurança** (mensal)
- 🔧 **Atualização de dependências** (trimestral)

---

## 🚨 Solução de Problemas

### Erro 500 - Internal Server Error
```
1. Verifique logs de erro no cPanel
2. Verifique permissões dos arquivos
3. Verifique arquivo .htaccess
4. Contate suporte se persistir
```

### Banco não conecta
```
1. Verifique dados de conexão
2. Teste via phpMyAdmin
3. Recrie usuário se necessário
4. Verifique se banco existe
```

### Site não carrega
```
1. Verifique DNS (pode demorar 48h)
2. Teste com IP direto
3. Verifique configuração do domínio
4. Limpe cache do navegador
```

### SSL não funciona
```
1. Aguarde processamento (até 24h)
2. Force renovação no cPanel
3. Verifique configuração do domínio
4. Entre em contato com suporte
```

---

## 📞 Suporte

### Hostgator VPS
- **Telefone:** 0800 600 2000
- **Chat:** Portal do cliente 24/7
- **Email:** Através do portal

### Sistema Villa Joias
- **Email:** suporte@villajoias.com.br
- **WhatsApp:** (11) 99999-9999
- **Horário:** Segunda a Sexta, 8h às 18h

### Documentação
- **Manual Completo:** MANUAL_CPANEL_VPS.md
- **Checklist:** CHECKLIST_CPANEL.md
- **API Docs:** /api/docs/

---

## 🎯 Próximos Passos

### Após Instalação
1. ✅ Configure dados da empresa
2. ✅ Crie primeiro caixa
3. ✅ Cadastre representantes
4. ✅ Teste todas funcionalidades

### Configuração WhatsApp (Próxima Fase)
1. 🔄 Escolher provedor de API
2. 🔄 Configurar Evolution API
3. 🔄 Integrar com sistema
4. 🔄 Testar cobrança automática

### Expansões Futuras
1. 🔄 App mobile nativo
2. 🔄 BI avançado
3. 🔄 Integração contábil
4. 🔄 Multi-empresa

---

## 🏆 Vantagens do cPanel

### Facilidade de Uso
- 🖱️ **Interface visual** - Sem comandos
- 📁 **Gerenciador de arquivos** integrado
- 🗄️ **Gestão de banco** simplificada
- 🔒 **SSL automático** com cliques

### Recursos Avançados
- 📊 **Monitoramento** em tempo real
- 🔄 **Backup** automático
- 📧 **Email** integrado
- 🛡️ **Segurança** avançada

### Suporte
- 📞 **Suporte 24/7** da Hostgator
- 📚 **Documentação** extensa
- 🎓 **Tutoriais** em vídeo
- 💬 **Comunidade** ativa

---

## 💎 Sistema Villa Joias cPanel Edition

**Desenvolvido especialmente para cPanel VPS**

✨ **Instalação visual em 15 minutos**  
✨ **Interface amigável e intuitiva**  
✨ **Performance otimizada**  
✨ **Segurança máxima**  
✨ **Backup automático**  
✨ **Suporte completo**  

**Transforme sua gestão financeira com facilidade!** 🚀

---

*Desenvolvido com excelência por Manus AI*  
*CIO Virtual da Villa Joias*  
*"Simplicidade visual, resultados profissionais"*

