# README - Instalação VPS - Sistema Villa Joias
## Guia Rápido para VPS Platinum Hostgator

**Versão:** 2.0 VPS Edition  
**Data:** 19 de Junho de 2025  
**Desenvolvido por:** Manus AI - CIO Villa Joias  

---

## 🚀 Instalação Rápida (5 Comandos)

### 1. Conecte no VPS via SSH
```bash
ssh root@SEU_IP_DO_VPS
```

### 2. Baixe os arquivos
```bash
wget https://seulink.com/villa_joias_vps_edition.tar.gz
tar -xzf villa_joias_vps_edition.tar.gz
cd villa_joias_vps_edition
```

### 3. Execute instalação automática
```bash
chmod +x install_vps.sh
./install_vps.sh
```

### 4. Configure seu domínio
```bash
./configure_domain.sh seudominio.com.br
```

### 5. Configure SSL
```bash
./configure_ssl.sh seudominio.com.br seu@email.com
```

**🎉 Pronto! Acesse: https://seudominio.com.br/install.php**

---

## 📁 Arquivos Incluídos

### Scripts de Instalação
- `install_vps.sh` - Instalação automática completa
- `configure_domain.sh` - Configuração de domínio
- `configure_ssl.sh` - Configuração SSL/HTTPS
- `monitor.sh` - Monitoramento do sistema

### Sistema Completo
- `villa_joias_api/` - Backend Python/Flask
- `villa_joias_frontend/` - Frontend React
- `database.sql` - Banco de dados (32 tabelas)
- `install.php` - Instalador web

### Documentação
- `MANUAL_VPS_VILLA_JOIAS.md` - Manual detalhado completo
- `README.md` - Este arquivo

---

## ⚙️ O que o Script Faz

### install_vps.sh
✅ Atualiza sistema Ubuntu  
✅ Instala Apache, MySQL, PHP 8.1  
✅ Configura firewall (UFW)  
✅ Cria banco de dados  
✅ Configura backup automático  
✅ Otimiza performance  
✅ Instala Certbot para SSL  

### configure_domain.sh
✅ Cria Virtual Host  
✅ Configura .htaccess  
✅ Ativa compressão GZIP  
✅ Configura cache  
✅ Adiciona headers de segurança  

### configure_ssl.sh
✅ Obtém certificado Let's Encrypt  
✅ Configura HTTPS automático  
✅ Força redirecionamento SSL  
✅ Configura renovação automática  

### monitor.sh
✅ Monitora serviços (Apache, MySQL)  
✅ Verifica uso de recursos  
✅ Analisa logs de erro  
✅ Verifica status SSL  
✅ Alertas automáticos  

---

## 🔐 Credenciais Padrão

### MySQL
- **Servidor:** localhost
- **Banco:** villa_joias
- **Usuário:** villa_admin
- **Senha:** VillaJoias2025!

### Administrador (definido na instalação web)
- **Email:** Você define
- **Senha:** Você define

---

## 📋 Requisitos VPS

### Mínimo Recomendado
- **RAM:** 2GB (VPS Platinum tem 8GB ✅)
- **CPU:** 2 cores (VPS Platinum tem 4 ✅)
- **Disco:** 20GB (VPS Platinum tem 200GB ✅)
- **OS:** Ubuntu 20.04+ ✅

### Portas Necessárias
- **22** - SSH
- **80** - HTTP
- **443** - HTTPS

---

## 🛠️ Comandos Úteis

### Verificar Status
```bash
./monitor.sh
```

### Backup Manual
```bash
/root/backup_villa_joias.sh
```

### Reiniciar Serviços
```bash
systemctl restart apache2
systemctl restart mysql
```

### Ver Logs
```bash
tail -f /var/log/apache2/villa_joias_error.log
tail -f /var/log/mysql/error.log
```

### Verificar SSL
```bash
certbot certificates
```

---

## 🚨 Solução de Problemas

### Erro 500 - Internal Server Error
```bash
# Verificar logs
tail -f /var/log/apache2/villa_joias_error.log

# Corrigir permissões
chown -R www-data:www-data /var/www/html/villa_joias
chmod -R 755 /var/www/html/villa_joias
```

### MySQL não conecta
```bash
# Verificar status
systemctl status mysql

# Reiniciar
systemctl restart mysql

# Testar conexão
mysql -u villa_admin -pVillaJoias2025! villa_joias
```

### Site não carrega
```bash
# Verificar Apache
systemctl status apache2

# Testar configuração
apache2ctl configtest

# Verificar DNS
nslookup seudominio.com.br
```

### SSL não funciona
```bash
# Verificar certificados
certbot certificates

# Renovar manualmente
certbot renew

# Verificar configuração
apache2ctl configtest
```

---

## 📞 Suporte

### Hostgator VPS
- **Telefone:** 0800 600 2000
- **Chat:** Portal do cliente

### Sistema Villa Joias
- **Email:** suporte@villajoias.com.br
- **WhatsApp:** (11) 99999-9999

### Logs para Suporte
```bash
# Informações do sistema
uname -a
cat /etc/os-release

# Status dos serviços
systemctl status apache2
systemctl status mysql

# Últimos erros
tail -20 /var/log/apache2/villa_joias_error.log
```

---

## 🎯 Próximos Passos

### Após Instalação
1. ✅ Acesse https://seudominio.com.br
2. ✅ Complete instalação web
3. ✅ Configure dados da empresa
4. ✅ Crie primeiro caixa
5. ✅ Cadastre representantes

### Configuração WhatsApp (Próxima Fase)
1. 🔄 Escolher provedor de API
2. 🔄 Configurar Evolution API
3. 🔄 Integrar com sistema
4. 🔄 Testar cobrança automática

---

## 🏆 Vantagens VPS vs Hospedagem Compartilhada

### Performance
- ⚡ **8x mais rápido** que hospedagem compartilhada
- ⚡ **Recursos dedicados** (8GB RAM, 4 CPUs)
- ⚡ **SSD NVMe** ultra-rápido

### Controle
- 🔧 **Acesso root** completo
- 🔧 **Instalar qualquer software**
- 🔧 **Configurações personalizadas**

### Escalabilidade
- 📈 **Suporta 1000+ usuários** simultâneos
- 📈 **WhatsApp ilimitado** com Evolution API
- 📈 **Múltiplos domínios** no mesmo servidor

### Segurança
- 🔒 **Firewall dedicado**
- 🔒 **SSL gratuito** Let's Encrypt
- 🔒 **Backup automático** diário
- 🔒 **Isolamento completo**

---

## 💎 Sistema Villa Joias VPS Edition

**Desenvolvido especialmente para VPS Platinum Hostgator**

✨ **Instalação em 10 minutos**  
✨ **Performance otimizada**  
✨ **Segurança máxima**  
✨ **Backup automático**  
✨ **SSL incluído**  
✨ **Monitoramento integrado**  

**Seu negócio merece o melhor!** 🚀

---

*Desenvolvido com excelência por Manus AI*  
*CIO Virtual da Villa Joias*  
*"Transformando VPS em sucesso"*

