#!/bin/bash

# Script de Instalação Automática - Sistema Villa Joias VPS
# Versão: 2.0 VPS Edition
# Data: 19/06/2025
# Autor: Manus AI - CIO Villa Joias

echo "🚀 INSTALAÇÃO AUTOMÁTICA - SISTEMA VILLA JOIAS VPS"
echo "=================================================="
echo ""

# Cores para output
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
BLUE='\033[0;34m'
NC='\033[0m' # No Color

# Função para log
log() {
    echo -e "${GREEN}[$(date +'%Y-%m-%d %H:%M:%S')] $1${NC}"
}

error() {
    echo -e "${RED}[ERRO] $1${NC}"
}

warning() {
    echo -e "${YELLOW}[AVISO] $1${NC}"
}

info() {
    echo -e "${BLUE}[INFO] $1${NC}"
}

# Verificar se é root
if [ "$EUID" -ne 0 ]; then
    error "Este script deve ser executado como root (sudo)"
    exit 1
fi

log "Iniciando instalação do Sistema Villa Joias..."

# Atualizar sistema
log "Atualizando sistema operacional..."
apt update && apt upgrade -y

# Instalar componentes essenciais
log "Instalando Apache..."
apt install apache2 -y

log "Instalando MySQL..."
apt install mysql-server -y

log "Instalando PHP e extensões..."
apt install php8.1 php8.1-mysql php8.1-curl php8.1-json php8.1-mbstring php8.1-xml php8.1-zip libapache2-mod-php8.1 -y

log "Instalando ferramentas extras..."
apt install curl wget unzip git nano htop ufw -y

# Configurar Apache
log "Configurando Apache..."
a2enmod rewrite
a2enmod ssl
a2enmod expires
a2enmod headers
a2enmod deflate

# Configurar PHP
log "Configurando PHP..."
sed -i 's/upload_max_filesize = .*/upload_max_filesize = 100M/' /etc/php/8.1/apache2/php.ini
sed -i 's/post_max_size = .*/post_max_size = 100M/' /etc/php/8.1/apache2/php.ini
sed -i 's/max_execution_time = .*/max_execution_time = 300/' /etc/php/8.1/apache2/php.ini
sed -i 's/memory_limit = .*/memory_limit = 512M/' /etc/php/8.1/apache2/php.ini

# Configurar Firewall
log "Configurando firewall..."
ufw default deny incoming
ufw default allow outgoing
ufw allow ssh
ufw allow 80/tcp
ufw allow 443/tcp
ufw --force enable

# Configurar MySQL
log "Configurando MySQL..."
mysql -e "ALTER USER 'root'@'localhost' IDENTIFIED WITH mysql_native_password BY 'VillaJoias2025!';"
mysql -e "DELETE FROM mysql.user WHERE User='';"
mysql -e "DELETE FROM mysql.user WHERE User='root' AND Host NOT IN ('localhost', '127.0.0.1', '::1');"
mysql -e "DROP DATABASE IF EXISTS test;"
mysql -e "DELETE FROM mysql.db WHERE Db='test' OR Db='test\\_%';"
mysql -e "FLUSH PRIVILEGES;"

# Criar banco e usuário
log "Criando banco de dados..."
mysql -u root -pVillaJoias2025! -e "CREATE DATABASE villa_joias CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;"
mysql -u root -pVillaJoias2025! -e "CREATE USER 'villa_admin'@'localhost' IDENTIFIED BY 'VillaJoias2025!';"
mysql -u root -pVillaJoias2025! -e "GRANT ALL PRIVILEGES ON villa_joias.* TO 'villa_admin'@'localhost';"
mysql -u root -pVillaJoias2025! -e "FLUSH PRIVILEGES;"

# Criar estrutura de pastas
log "Criando estrutura de pastas..."
mkdir -p /var/www/html/villa_joias
mkdir -p /var/www/html/villa_joias/uploads
mkdir -p /var/www/html/villa_joias/backups
mkdir -p /var/www/html/villa_joias/logs
mkdir -p /root/backups

# Configurar permissões
log "Configurando permissões..."
chown -R www-data:www-data /var/www/html/villa_joias
chmod -R 755 /var/www/html/villa_joias
chmod 777 /var/www/html/villa_joias/uploads
chmod 777 /var/www/html/villa_joias/backups
chmod 777 /var/www/html/villa_joias/logs

# Configurar swap
log "Configurando memória virtual (swap)..."
if [ ! -f /swapfile ]; then
    fallocate -l 2G /swapfile
    chmod 600 /swapfile
    mkswap /swapfile
    swapon /swapfile
    echo '/swapfile none swap sw 0 0' >> /etc/fstab
fi

# Criar script de backup
log "Configurando backup automático..."
cat > /root/backup_villa_joias.sh << 'EOF'
#!/bin/bash
DATE=$(date +%Y%m%d_%H%M%S)
BACKUP_DIR="/root/backups"
DB_NAME="villa_joias"
DB_USER="villa_admin"
DB_PASS="VillaJoias2025!"

mkdir -p $BACKUP_DIR
mysqldump -u $DB_USER -p$DB_PASS $DB_NAME > $BACKUP_DIR/db_$DATE.sql
tar -czf $BACKUP_DIR/files_$DATE.tar.gz /var/www/html/villa_joias
find $BACKUP_DIR -name "*.sql" -mtime +7 -delete
find $BACKUP_DIR -name "*.tar.gz" -mtime +7 -delete
echo "Backup concluído: $DATE"
EOF

chmod +x /root/backup_villa_joias.sh

# Agendar backup diário
log "Agendando backup diário..."
(crontab -l 2>/dev/null; echo "0 2 * * * /root/backup_villa_joias.sh >> /var/log/backup.log 2>&1") | crontab -

# Otimizar MySQL
log "Otimizando MySQL..."
cat >> /etc/mysql/mysql.conf.d/mysqld.cnf << EOF

# Otimizações Villa Joias
innodb_buffer_pool_size = 2G
innodb_log_file_size = 256M
innodb_flush_log_at_trx_commit = 2
query_cache_type = 1
query_cache_size = 256M
max_connections = 200
EOF

# Reiniciar serviços
log "Reiniciando serviços..."
systemctl restart apache2
systemctl restart mysql

# Verificar status
log "Verificando status dos serviços..."
if systemctl is-active --quiet apache2; then
    log "✅ Apache está rodando"
else
    error "❌ Apache não está rodando"
fi

if systemctl is-active --quiet mysql; then
    log "✅ MySQL está rodando"
else
    error "❌ MySQL não está rodando"
fi

# Instalar Certbot para SSL
log "Instalando Certbot para SSL..."
apt install snapd -y
snap install core
snap refresh core
snap install --classic certbot
ln -sf /snap/bin/certbot /usr/bin/certbot

echo ""
echo "🎉 INSTALAÇÃO BÁSICA CONCLUÍDA!"
echo "================================"
echo ""
echo "✅ Apache instalado e configurado"
echo "✅ MySQL instalado e configurado"
echo "✅ PHP 8.1 instalado e otimizado"
echo "✅ Firewall configurado"
echo "✅ Banco de dados criado"
echo "✅ Backup automático configurado"
echo "✅ Certbot instalado para SSL"
echo ""
echo "📋 PRÓXIMOS PASSOS:"
echo "1. Faça upload dos arquivos do sistema para /var/www/html/villa_joias/"
echo "2. Configure o Virtual Host para seu domínio"
echo "3. Execute o instalador web: http://seudominio.com.br/install.php"
echo "4. Configure SSL: certbot --apache -d seudominio.com.br"
echo ""
echo "🔐 CREDENCIAIS DO BANCO:"
echo "Servidor: localhost"
echo "Banco: villa_joias"
echo "Usuário: villa_admin"
echo "Senha: VillaJoias2025!"
echo ""
echo "📞 SUPORTE: suporte@villajoias.com.br"
echo ""

