import React, { useState, useEffect } from 'react';
import { BrowserRouter as Router, Routes, Route, Navigate } from 'react-router-dom'
import './App.css'
import Dashboard from './components/Dashboard'
import CobrancaModule from './components/CobrancaModule'
import UsuariosModule from './components/UsuariosModule'
import BackupModule from './components/BackupModule'
import Sidebar from './components/Sidebar'
import ChatManus from './components/ChatManus'

// Componente de Login
const Login = ({ onLogin }) => {
  const [email, setEmail] = useState('admin@villajoias.com')
  const [password, setPassword] = useState('123456')

  const handleSubmit = (e) => {
    e.preventDefault()
    // Simulação de login
    if (email && password) {
      onLogin(true)
    }
  }

  return (
    <div className="min-h-screen bg-gradient-to-br from-gray-900 via-gray-800 to-black flex items-center justify-center">
      <div className="max-w-md w-full space-y-8 p-8">
        <div className="text-center">
          <div className="mx-auto h-16 w-16 bg-gradient-to-br from-yellow-400 to-yellow-600 rounded-xl flex items-center justify-center mb-4">
            <span className="text-black font-bold text-2xl">VJ</span>
          </div>
          <h2 className="text-3xl font-bold text-white">Villa Joias</h2>
          <p className="mt-2 text-gray-400">Sistema de Controle Financeiro</p>
        </div>
        
        <form className="mt-8 space-y-6" onSubmit={handleSubmit}>
          <div className="space-y-4">
            <div>
              <label htmlFor="email" className="block text-sm font-medium text-gray-300">
                Email
              </label>
              <input
                id="email"
                name="email"
                type="email"
                value={email}
                onChange={(e) => setEmail(e.target.value)}
                className="mt-1 block w-full px-3 py-2 bg-gray-700 border border-gray-600 rounded-md text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-yellow-500 focus:border-transparent"
                placeholder="Digite seu email"
              />
            </div>
            <div>
              <label htmlFor="password" className="block text-sm font-medium text-gray-300">
                Senha
              </label>
              <input
                id="password"
                name="password"
                type="password"
                value={password}
                onChange={(e) => setPassword(e.target.value)}
                className="mt-1 block w-full px-3 py-2 bg-gray-700 border border-gray-600 rounded-md text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-yellow-500 focus:border-transparent"
                placeholder="Digite sua senha"
              />
            </div>
          </div>

          <button
            type="submit"
            className="group relative w-full flex justify-center py-3 px-4 border border-transparent text-sm font-medium rounded-md text-black bg-gradient-to-r from-yellow-400 to-yellow-600 hover:from-yellow-500 hover:to-yellow-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-yellow-500 transition-all duration-200"
          >
            Entrar no Sistema
          </button>
        </form>
      </div>
    </div>
  )
}

// Componente Principal
function App() {
  const [isAuthenticated, setIsAuthenticated] = useState(false)

  // Verificar se já está logado
  useEffect(() => {
    const token = localStorage.getItem('villa_joias_token')
    if (token) {
      setIsAuthenticated(true)
    }
  }, [])

  const handleLogin = (success) => {
    if (success) {
      localStorage.setItem('villa_joias_token', 'demo_token')
      setIsAuthenticated(true)
    }
  }

  if (!isAuthenticated) {
    return <Login onLogin={handleLogin} />
  }

  // Sistema completo com sidebar e chat Manus
  return (
    <Router>
      <div className="App">
        <Sidebar>
          <Routes>
            <Route path="/" element={<Navigate to="/dashboard" replace />} />
            <Route path="/dashboard" element={<Dashboard />} />
            <Route path="/cobranca" element={<CobrancaModule />} />
            <Route path="/usuarios" element={<UsuariosModule />} />
            <Route path="/backup" element={<BackupModule />} />
            <Route path="*" element={<Navigate to="/dashboard" replace />} />
          </Routes>
        </Sidebar>
        
        {/* Chat Manus sempre disponível */}
        <ChatManus />
      </div>
    </Router>
  )
}

export default App

